# 第二章 开源开发者发展现状
开源软件在全球技术发展中已成为不可或缺的一部分，并对技术创新、合作和贡献产生了深远影响。开源为开发者提供了一个具有开放性、透明性的自由交流、分享、协作的平台。与此同时，开发者立足于项目、企业、社区、基金会，通过编写、测试和优化代码，以及运营、治理等方式，深度参与开源的创造、贡献、建设，在开源项目的成功、社区的生态繁荣、百业同鸣历程中起着至关重要的作用。

## 2.1	 中国开源开发者规模、增速及发展趋势

### 1）开发者基本画像

《全球开源生态研究报告》指出，得益于开源写入“十四五”规划，国家层面对开源的重视程度不断加深，相较往年开源支持政策体现在新技术发展得推动方式，近年开源政策更加体系化和多样化。在此趋势下，企业重视程序持续提高，开发者队伍日渐庞大。

中国开源开发者的数量呈现出快速增长的趋势。据GitHub 2022年数据统计，GitHub平台开发者数量达到9400万开发者，开发者同比增长 27%，新增用户超过2050万，全球有90%的公司在使用开源，2022年有4.13亿次开源贡献。

按照国家/地区来划分，2022年中中国新增开发者数量占GitHub新增开发者数百分比为15.6%。据2023 年4月工信部透露，我国开源软件开发者数量已经突破800万，居全球第二，中国开源开发者的增速令人瞩目。

![全球开源开发者增长的地区Top10](https://img-blog.csdnimg.cn/880e5be67dec42908544e31f0ec57d16.png)全球开源开发者快速增长的地区Top10
全球开源开发者增长的地区Top10

据CSDN GitCode、PingCAP OSSInsight、北京大学软件与微电子学院荆琦副教授联合出品的《2022 中国开源贡献度报告》统计，中国拥有占全球30%的最大规模开发者群体，开源增长空间和潜力巨大。该报告以两年作为统计期，全球贡献者（以邮箱统计）共计 213,982人，贡献者地区为中国的用户数为10,691人（仅包括填写地区的中国贡献者），预计中国开发者占总贡献者的数量约为9.5%（假设未填写地区的和填写地区的中国贡献者比例分布一致）。

![中国开发者占比](https://img-blog.csdnimg.cn/7d7bbe3c45434561a19e33e076a06584.png)
中国开发者占比

基于国内主流的技术社区及论坛的注册用户数，观察中国开发者的整体增长趋势时发现，中国开发者社区CSDN，拥有注册账号是8700万，而注册用户在排重以后是4200万，相较2021年新增了600万用户。这新增的600万用户里，新增用户中有60%都是大学生和高中生，高校计算机专业学生覆盖度90%，非常的年轻化。与此同时，CSDN已推出开源代码托管平台GitCode，为中国开源生态提供源代码托管、项目管理、DevOps、安全扫描、安全监控等免费服务；推出开源工具平台InsCode，打造面向开发者的集编程，创作，分享于一体的全新共创开源社区，为开源人才的学习和成长赋能。

根据开源社区Gitee统计，2022年Gitee新增了200万的用户，平台仓库数量达到2500万，新仓库数量为480万，总用户数达到1000万。

### 2）开发者行业、地域、技术特点等

根据CSDN发布的《2022-2023 中国开发者调查报告》显示，我们将开发者根据年龄范围划分成三类发现，30岁以下的开发者人数占71%，本科及以上学历占8成，89%的开发者都是男性。软件行业涵盖了国内近半数开发者，40岁以下的开发者从事后端开发的比例最高。40岁以上开发者主要担任技术经理以及架构师的职位，所属行业重点分布在互联网、软件、教育领域。

![开发者基本特征](https://img-blog.csdnimg.cn/89105270653945e19eea3b5255773ef6.png)
开发者基本特征

全国超过40%的开发者工作在一线城市（其中以北京、上海、广州、深圳为主）。北京、广东是开发者聚集较多的地域，占全国总数28.2%。上海、江苏地区的开发者占比数量处于第二梯队，占全国总数的15.1%。

![开发者地域分布（省、自治区、直辖市、特别行政区）Top 15](https://img-blog.csdnimg.cn/98aa0db66a2b404c9aa14f681ef875e8.png)
开发者地域分布（省、自治区、直辖市、特别行政区）Top 15

开源正在吞噬世界，在日常的开发工作中，无可避免地要使用到开源软件，数据显示，96%的开发者正在使用开源软件，仅有2%的开发者表示从未使用开源软件。

![开发者是否使用过开源软件比例](https://img-blog.csdnimg.cn/c7d4d0a1d6584df690e73d66240d8288.png) 
开发者是否使用过开源软件比例

当然，开发者在使用开源开源的过程中，也参与开源、回馈开源。相较去年42%的开发者参与过开源，今年有较大幅的增长，49%的开发者参与过开源项目，接近一半的开发者加入了开源的大队伍。

![开发者参与开源项目的比例](https://img-blog.csdnimg.cn/ccfaec9708c14e5eba62fce0cf4d5316.png)
开发者参与开源项目的比例

67%的开发者每周在开源上投入的时间不超过5小时，随着开源的发展，有更多的人从事开源相关的工作，数据显示，有4%的开发者每周在开源上投入30小时以上。

![开发者在开源上花费的时间](https://img-blog.csdnimg.cn/e5f09ba4702044fea7e9521aafade0c1.png)
开发者在开源上花费的时间

在开源项目的贡献上，主要还是通过代码和文档的贡献，在参与过开源项目的开发者中，有72.9%的开发者有代码贡献，49%开发者有文档贡献。

![开发者参与开源的方式](https://img-blog.csdnimg.cn/931c005ec6b3480ea77a10d2876f55f5.png)
开发者参与开源的方式

互联网产品是开发者首次接触开源项目的类别，占比36%，越来越多的产品正在使用开源项目进行构建。

![开发者首次接触开源项目类别](https://img-blog.csdnimg.cn/e907c89298594f639959426aa8a3edbe.png)
开发者首次接触开源项目类别

在开源项目中，Java依然是最常用的开发语言，有41%的开发者表示，在开源项目中经常会使用到。其次是Python，占比27%。

![开源中常用的开发语言](https://img-blog.csdnimg.cn/f4ac449747cc41db90aabe328b78da0b.png)
开源中常用的开发语言

国内的开源项目，基本都会建立一个QQ群，用于社区成员交流。数据显示，QQ群、邮件列表、微信为三大主要交流工具。

![开源社区成员交流工具](https://img-blog.csdnimg.cn/54daa06af44742b8ab44d79733e82809.png)
开源社区成员交流工具

中国开源开发者在各个技术领域都有涉猎和贡献。从人工智能、大数据到区块链、云计算等领域，中国开发者在各个前沿技术的开源项目中都有积极参与和贡献。他们不仅关注国内的开源项目，也积极参与到国际开源社区中，与全球开发者共同推动技术的进步。人工智能的发展，吸引了众多开发者的目光，45%的开发者比较关注开源AI，其次是编程语言。

![开发者关注的开源技术领域](https://img-blog.csdnimg.cn/29ffb01c7c7f4715b19eef7917eb1d11.png)
开发者关注的开源技术领域

随着近几年操作系统的热度提升，开发者最希望看到操作系统相关的开源项目。

![开发者最希望开源的项目](https://img-blog.csdnimg.cn/1cac500e77324f47a7493b8796e868c8.png)
开发者最希望开源的项目

## 2.2 开源开发者对开源社区、开源活动和开源项目的投入和贡献

数据显示，开放透明的代码和知识共享是吸引众多开发者使用开源软件的最大因素之一，占比55.8%。为了促进开源生态的可持续发展，越来越多的开源社区和组织在中国成立，为开发者提供了学习、交流和合作的平台。同时，一些国内知名的技术企业也在积极推动开源文化，通过开源项目和活动，促进开发者之间的合作和创新。

![吸引开发者使用开源软件的因素](https://img-blog.csdnimg.cn/ea73c4731028438cbd80875a37382fb4.png)
吸引开发者使用开源软件的因素

### 1）开源社区和开源活动

根据开源社汇总的《中国开源地图》，2022年中国开源社区新增21个组织，增幅明显。在2021年，开源社区增速最快，一年新增42个。

![社区创始年表](https://img-blog.csdnimg.cn/394c5ad35082436185ebc0b07f1c7d58.png)
社区创始年表

就地域而言，多数社区聚集在北京地区，共有69个社区，包括Apache IoTDB、开源GitOps产业联盟、Apache ShardingSphere、Apache Doris、亚马逊云科技、OceanBase等。杭州的开源社区数量排名第二，有Apache RocketMQ、阿里云PolarDB开源社区、Ruby China、龙蜥社区、KubeEdge等19个。上海地区也有19个开源社区，覆盖KubeSphere、Neo4j开发者社区、OpenMLDB社区、X-lab开放实验室等。

![社区城市排行](https://img-blog.csdnimg.cn/7666583e8715434388f40d0e034b9c90.png)
社区城市排行

大数据在开源社区领域的类别中数量最高，有46个。一方面，在数字化时代，大数据发展起步较早，行业对大数据技术和工具的需求非常高；另一方面，大数据领域的技术非常复杂，涉及到分布式计算、数据存储和处理乃至机器学习等多个方面，这也涌现了Hadoop、Spark、Kafka等成熟的技术工具和框架。云原生和云计算开源社区数量排在第二和第三位，分别有43个和39个。中间件、机器学习、数据库的社区数量在近几年增长迅速，如今均达到了31个。

![社区领域排行](https://img-blog.csdnimg.cn/02a2b7f365344744841d926238c3dc64.png)
社区领域排行

在过去一年，国内举办了多场开源社区活动和会议，为开发者提供了学习和交流的机会。例如：

-  2022开放原子全球开源峰会于2022年7月27-29日在北京成功举办。本届峰会以“软件定义世界，开源共筑未来”为主题，以立足中国、面向世界的姿态，宣扬开源成果，传递“开放共享、共建共治”理念，打造成为国际开源盛会，赢得社会各界广泛好评和高度关注。
- 由开源社举办的2022第七届中国开源年会（COSCon 2022）在2022年10月29日-30日于线上成功举办，这次会议以“Open the World ! ”为主题，以Open对抗Close、以Connection对抗Broken、以Public Good对抗Bad News，希望能以开源的技术、开源的方式、开源的力量，治愈这个世界。
- 2022 CCF中国开源大会以“开源创新，引领未来”为主题，组织特邀报告、开源高峰论坛、开源发展委员会视频秀、社区论坛、技术论坛、教育论坛等20余个不同类型的活动。大会邀请10余位开源及相关领域中国科学院院士、中国工程院院士与知名专家，为大会带来特邀报告并参加开源高峰论坛等活动。
- 2022 长沙 · 中国1024程序员节于2022 年10月23 - 25日在长沙、北京等多地同步举行。本次程序员节以“算力新时代，开源创未来”为活动主题，由5大院士领衔，四城联动，开设十余场专业主题论坛，覆盖AI、芯片、数据库、大数据、数字化转型、工业互联网等技术领域，囊括中国根技术掌门人、8大海外开源技术掌门人等多场尖峰对话环节，以及代码比拼、企业创新展等特色嘉年华活动。
- 全球开源技术峰会（Global Open-source Technology Conference，简称 GOTC），是由上海浦东软件园、开放原子开源基金会、Linux 基金会亚太区和开源中国联合发起的，面向全球开发者的一场盛大开源技术盛宴。GOTC 2023在2023年5月27日-28日上海成功举办，这次开源行业盛会以行业展览、主题发言、特别论坛、分论坛的形式展现，与会者将一起探讨元宇宙、3D 与游戏、eBPF、Web3.0、区块链等热门技术主题，以及开源社区、开源商业化、开源教育培训、云原生等热门话题，探讨开源未来，助力开源发展。

### 2）开源项目

《2022 中国开源贡献度报告》根据每个项目中提交是否为中国开发者的提交，按照大于标注为中国地区开发者的提交占比超过40%为主要标准，外加CSDN、Gitee等国内社区标签信息为参考，确认674个项目为中国开发者主导的项目，占比约12.5%。

![中国项目占比](https://img-blog.csdnimg.cn/f2a145c33864463c8135677e401f631e.png)
中国项目占比

一个值得关注的数据是：在674个中国项目两年内收到的343,735个提交中，标注地区信息的开发者提交数为205,528。其中，中国开发者的提交136,350，占比66.3%。国际开发者提交69,178，占比33.7%。国际开发者高于三成的参与率，说明中国的开源项目正在走向全球，引起了全球开发者的关注。

![中国项目贡献分布](https://img-blog.csdnimg.cn/650aee25609f416fa0515283e8772ffd.png)
中国项目贡献分布

这意味着中国开源势力已经开始登上国际化的舞台。报告根据GitHub Event的数据，汇总出“中国开源项目 Top20”（注：由于本轮发布项目排行数据主要参考GitHub中Event数据，目前在GitHub中没有数据的项目尚未计算在内，例如OpenHarmony、openEuler、 MindSpore等）。

榜单上，位列前五的是ant-design、 vue-element-admin、echarts、frp，以及 dubbo。有五个项目的Star数超过五万，Fork数最高为ant-design的36,086，贡献者近两千人。值得注意的是，Top20的项目中，阿里系占到6席（包括阿里巴巴、蚂蚁集团和饿了么），这与阿里在GitHub上的长期沉淀不无关系。早在五年前，阿里就成为唯一一家入围GitHub顶尖贡献名单的中国公司。

![中国开源项目TOP 20](https://img-blog.csdnimg.cn/45ea8080bf7d4ddd9de0b115ca7b208b.png)
中国开源项目TOP 20

根据《2022 中国开源年度报告》，中国项目中，排名前两名的项目遥遥领先，后续项目OpenRank值相近，说明中国开源项目正在平稳发展。Top30榜单中，我们发现中国顶尖开源项目在前端、数据库、云原生、人工智能领域表现突出。其中ant-design/ant-design表现优异，项目参与者方面，ant-design达到了最高的3882 人，巴士系数也达到了2530人，在issue解决时间以及活跃度方面也有不错的表现。

![中国项目OpenRank排名Top30](https://img-blog.csdnimg.cn/8ddec329b1a54f30a4a9bc10c7930175.png)
中国项目OpenRank排名Top30

全球贡献排名前50的公司中有10家国内企业上榜。整体来看，前五分别是谷歌、脸书、英特尔、红帽，以及美国超威半导体。中国上榜公司包括华为、阿里巴巴、联发科（中国台湾）、腾讯、乐鑫科技、百度、字节跳动、中兴、瑞昱（中国台湾），以及涛思数据。其中，华为的贡献度遥遥领先，排在第六，前三十中还有阿里巴巴和联发科，其余七家在30到50位之间。

![全球公司开源贡献榜TOP 50](https://img-blog.csdnimg.cn/eb97e753eb924d7b9bd89315b7185d39.png)
全球公司开源贡献榜TOP 50

在国内，通信、互联网、大数据、云、电子等领域的头部公司对开源作出重要贡献。

![中国公司开源贡献榜TOP 20](https://img-blog.csdnimg.cn/8a4445bc82ed404296ae71ca6ef82433.png)
中国公司开源贡献榜TOP 20

在捐献到Apache Software Foundation和Linux Foundation的中国项⽬中，Apache项⽬的整体数据表现亮眼，ShardingSphere、Pulsar、Flink、tvm等项⽬名列前茅，值得指出的是，Flink在没有使⽤GitHubIssue功能的情况下影响⼒第三，活跃程度可⻅⼀斑。

![基金会中中国项目排行Top20](https://img-blog.csdnimg.cn/1e738bb96cd240a687054d6ba40a34c1.png)
基金会中中国项目排行Top20




## 2.3 开源开发者的需求和面临的挑战

### 1）调研需求分析

虽然近年来，中国的开源发展速度非常迅猛，且自2021年以来Apache基金会的孵化项目基本都来自中国，未来中国必将会是参与国际开源的一股重要的力量。

不过，《2022中国开源贡献度报告》指出，当下从项目来看，主流开源项目国内席位稀少，国际开源Top50项目中，中国只有ant-design和vue-element-admin两个项目上榜，排名17和26，均为前端项目。

![国际开源项目Top50](https://img-blog.csdnimg.cn/5f02a6e35431472eb510a3d3ca48398b.png)
国际开源项目Top50

从开发者角度来看，开发者对于开源协议、内源、开源办公室等含义的理解与适用的程度还远远不足。据CSDN《2022-2023中国开发者调查报告》显示，在各家公司开始发力内源（InnerSource）加速公司类部代码共享初期，仅14%的开发者对其有较深入的了解。要想更好的发展内源，各公司还需要加大投入。

![开发者对内源的了解程度](https://img-blog.csdnimg.cn/b43feb32d42b4da5af494377b14eae35.png)
开发者对内源的了解程度


此外，开源协议是开源的重中之重，在开发者中，了解最多的是Apache许可证，占⽐43.8%，其次是MIT许可证。 值得注意的是，依然有21.4%的开发者在使⽤开源项⽬时，没有关注过开源协议就直接进⾏使⽤，这可能使自己以及所在的企业陷入开源合规风险。

![开发者了解的开源许可证](https://img-blog.csdnimg.cn/f057f64b35e74b27be3321d4d2e2c177.png)
开发者了解的开源许可证

国内外有很多公司在开源浪潮下都建立了开源办公室，主要职能是设置代码使用、分发、选择、审计相关政策、培训开发人员等。到目前为止，还有超过半数的开发者完全没有听过开源办公室。

![开发者对开源办公室（OSPO）的了解程度](https://img-blog.csdnimg.cn/dc402437baad41a083323767e24b424e.png)
开发者对开源办公室（OSPO）的了解程度

与此同时，63%的开发者表示未曾在开源中获得收入，依然在用爱发电，依然靠着自己的热爱在勉力支撑。实际上，这样的状况，已经到了迫切需要改变的时候了，否则，下一个类似colors.js作者直接“删库”最终导致数千个应用程序无限输出乱码的悲剧，依然会发生。

![开发者在开源上获得的收入](https://img-blog.csdnimg.cn/7d78dbecc2454104a3e51af8960ae09d.png)
开发者在开源上获得的收入

### 2）建议

基于以上挑战，需要开源社区和相关企业共同协力解决，从而更好地推动整个行业向更加开放、透明、合作的方向发展。在此，分享一些建议和措施：

1. 提升国际化影响力：

- 提供培训、指导和资源，鼓励和支持中国开源开发者积极参与和贡献到全球主流开源项目中，帮助他们融入全球开源社区。
- 打造高质量的开源项目，能够满足国际标准和需求，推动中国开源项目在全球开源社区中的知名度和影响力，提高其在全球主流开源项目中的席位。
- 提供良好的中英文文档、教程和示例代码，帮助新用户更好地了解和使用项目。同时，及时响应用户的反馈和问题，不断改进和优化项目。
- 多参与国际开源标准和组织，与全球开源社区保持密切联系。

2. 加强内源理解和实践：

- 提供培训和教育资源，帮助企业内部员工、开发者深入理解内源的概念和实践，并在项目开发中积极采用内源模式。
- 建立内源文化和价值观：强调开放合作、共享知识和透明沟通的价值通过奖励机制、认可制度或内源贡献者的称号，激励开发者积极参与内源实践。
- 提供支持和反馈渠道：建立一个反馈渠道，让开发者能够提出问题、分享经验和寻求支持。

3. 加强开源文化的推广：

- 加大宣传力度，提高开发者对开源办公室的认知。举办开源活动、研讨会和培训，让更多开发者了解开源文化和实践的重要性。
- 建立开源社区的合作机制，促进开源办公室与开发者之间的联系和交流，共同推动开源的发展。

4. 开发者收入机制的改进：

- 探索多元化的开源项目收入模式，例如基于赞助、捐赠、咨询服务和定制开发等方式，为开源开发者提供更多的收入来源。
- 建立合理的激励机制，鼓励开发者在开源项目中的贡献，并将其贡献价值化，以吸引更多开发者积极参与和贡献。

总的来说，提升中国开源开发者的国际化影响力、加强内源理解和实践、推广开源文化以及改进开发者收入机制，这些努力将有助于解决中国开源开发者面临的挑战，并推动中国开源生态系统的发展。

